/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.LogWriter;
import noppes.npcs.api.entity.data.IAnimationPart;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.util.ValueUtil;

public class PartConfig
implements IAnimationPart {
    public final float[] rotation = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public final float[] offset = new float[]{0.0f, 0.0f, 0.0f};
    public final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public int id = 0;
    public boolean disable = false;
    public boolean show = true;
    public String name = "";
    protected EnumParts type = EnumParts.HEAD;

    public PartConfig() {
        this.clear();
        this.setMainName();
    }

    public PartConfig(int id, EnumParts type) {
        this();
        this.id = id;
        this.type = type;
        this.setMainName();
    }

    private void setMainName() {
        if (this.id > 7) {
            if (this.name.isEmpty()) {
                this.name = "part_" + this.type.name().toLowerCase() + "_" + this.id;
            }
            return;
        }
        switch (this.id) {
            case 0: {
                this.name = "model.head";
                break;
            }
            case 1: {
                this.name = "model.larm";
                break;
            }
            case 2: {
                this.name = "model.rarm";
                break;
            }
            case 3: {
                this.name = "model.body";
                break;
            }
            case 4: {
                this.name = "model.lleg";
                break;
            }
            case 5: {
                this.name = "model.rleg";
                break;
            }
            case 6: {
                this.name = "model.lstack";
                break;
            }
            case 7: {
                this.name = "model.rstack";
            }
        }
    }

    @Override
    public int getType() {
        return this.type.ordinal();
    }

    public EnumParts getEnumType() {
        return this.type;
    }

    @Override
    public void clear() {
        for (int i = 0; i < 5; ++i) {
            this.rotation[i] = 0.0f;
            if (i > 2) continue;
            this.offset[i] = 0.0f;
            this.scale[i] = 1.0f;
        }
    }

    public PartConfig copy() {
        PartConfig pc = new PartConfig();
        pc.load(this.save());
        return pc;
    }

    @Override
    public float[] getOffset() {
        return new float[]{this.offset[0], this.offset[1], this.offset[2]};
    }

    @Override
    public float[] getRotation() {
        return new float[]{this.rotation[0], this.rotation[1], this.rotation[2]};
    }

    @Override
    public float[] getRotationPart() {
        return new float[]{this.rotation[3], this.rotation[4]};
    }

    @Override
    public float[] getScale() {
        return new float[]{this.scale[0], this.scale[1], this.scale[2]};
    }

    @Override
    public boolean isDisable() {
        return this.disable;
    }

    @Override
    public boolean isShow() {
        return this.show;
    }

    public void load(NBTTagCompound compound) {
        int v = compound.func_74762_e("v");
        float pi = (float)Math.PI;
        for (int i = 0; i < 5; ++i) {
            float valueR = compound.func_150295_c("Rotation", 5).func_150308_e(i);
            float valueO = compound.func_150295_c("Offset", 5).func_150308_e(i);
            float valueS = compound.func_150295_c("Scale", 5).func_150308_e(i);
            try {
                float corr = (float)Math.PI / (i == 4 ? 2.0f : 1.0f);
                this.rotation[i] = v == 0 ? ValueUtil.correctFloat((2.0f * pi * valueR - pi) / (i == 4 ? 2.0f : 1.0f), -corr, corr) : ValueUtil.correctFloat(valueR, -corr, corr);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (i > 2) continue;
            try {
                this.offset[i] = v == 0 ? ValueUtil.correctFloat(valueO * 10.0f - 5.0f, -5.0f, 5.0f) : ValueUtil.correctFloat(valueO, -5.0f, 5.0f);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            try {
                if (v == 0) {
                    this.scale[i] = ValueUtil.correctFloat(valueS * 5.0f, 0.0f, 5.0f);
                    continue;
                }
                this.scale[i] = ValueUtil.correctFloat(valueS, 0.0f, 5.0f);
                continue;
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        this.id = compound.func_74762_e("Part");
        if (compound.func_150297_b("Disabled", 1)) {
            this.disable = compound.func_74767_n("Disabled");
        }
        if (compound.func_150297_b("Show", 1)) {
            this.show = compound.func_74767_n("Show");
        }
        if (compound.func_150297_b("Name", 8)) {
            this.name = compound.func_74779_i("Name");
        }
        this.setMainName();
        if (compound.func_150297_b("Type", 3)) {
            this.type = EnumParts.values()[compound.func_74762_e("Type")];
        }
    }

    @Override
    public void setDisable(boolean bo) {
        this.disable = bo;
    }

    @Override
    public void setOffset(float x, float y, float z) {
        this.offset[0] = ValueUtil.correctFloat((x %= 5.0f) / 5.0f, 0.0f, 1.0f);
        this.offset[1] = ValueUtil.correctFloat((y %= 5.0f) / 5.0f, 0.0f, 1.0f);
        this.offset[2] = ValueUtil.correctFloat((z %= 5.0f) / 5.0f, 0.0f, 1.0f);
    }

    @Override
    public void setRotation(float x, float y, float z) {
        float pi = (float)Math.PI;
        this.rotation[0] = ValueUtil.correctFloat((x %= 180.0f) / 180.0f * pi, -pi, pi);
        this.rotation[1] = ValueUtil.correctFloat((y %= 180.0f) / 180.0f * pi, -pi, pi);
        this.rotation[2] = ValueUtil.correctFloat((z %= 180.0f) / 180.0f * pi, -pi, pi);
    }

    @Override
    public void setRotation(float x1, float y1) {
        float pi = (float)Math.PI;
        this.rotation[3] = ValueUtil.correctFloat((x1 %= 90.0f) / 180.0f * pi, -pi, pi);
        this.rotation[4] = ValueUtil.correctFloat((y1 %= 90.0f) / 180.0f * pi, -pi, pi);
    }

    @Override
    public void setScale(float x, float y, float z) {
        this.scale[0] = ValueUtil.correctFloat((x %= 5.0f) / 5.0f, 0.0f, 1.0f);
        this.scale[1] = ValueUtil.correctFloat((y %= 5.0f) / 5.0f, 0.0f, 1.0f);
        this.scale[2] = ValueUtil.correctFloat((z %= 5.0f) / 5.0f, 0.0f, 1.0f);
    }

    @Override
    public void setShow(boolean bo) {
        this.show = bo;
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listRot = new NBTTagList();
        NBTTagList listOff = new NBTTagList();
        NBTTagList listSc = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            listRot.func_74742_a((NBTBase)new NBTTagFloat(this.rotation[i]));
            listOff.func_74742_a((NBTBase)new NBTTagFloat(this.offset[i]));
            listSc.func_74742_a((NBTBase)new NBTTagFloat(this.scale[i]));
        }
        listRot.func_74742_a((NBTBase)new NBTTagFloat(this.rotation[3]));
        listRot.func_74742_a((NBTBase)new NBTTagFloat(this.rotation[4]));
        compound.func_74782_a("Rotation", (NBTBase)listRot);
        compound.func_74782_a("Offset", (NBTBase)listOff);
        compound.func_74782_a("Scale", (NBTBase)listSc);
        compound.func_74768_a("Part", this.id);
        compound.func_74757_a("Disabled", this.disable);
        compound.func_74757_a("Show", this.show);
        compound.func_74778_a("Name", this.name);
        compound.func_74768_a("Type", this.type.ordinal());
        compound.func_74768_a("v", 1);
        return compound;
    }

    public void set(Float[] inBase) {
        if (inBase == null) {
            this.clear();
            return;
        }
        for (int i = 0; i < 11; ++i) {
            if (inBase.length <= i) continue;
            if (i < 3) {
                this.rotation[i] = inBase[i].floatValue();
                continue;
            }
            if (i < 6) {
                this.offset[i - 3] = inBase[i].floatValue();
                continue;
            }
            if (i < 9) {
                this.scale[i - 6] = inBase[i].floatValue();
                continue;
            }
            this.rotation[i - 6] = inBase[i].floatValue();
        }
    }
}

